package com.ejie.aa17a.informes;

import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;

import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.model.Aa17aInformeFiltro;
import com.ejie.aa17a.utilidades.Aa17aConstantes;
import com.ejie.aa17a.utilidades.Aa17aFuncionesComunes;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;

/**
 * 
 * @author francisco.galvez
 * 
 */
public class Aa17aInformesPDF {

	private MessageSource pdfMessageSource;
	private Locale locale = LocaleContextHolder.getLocale();

	private static final int ESCALA_IMAGEN = 80;

	private static final float PORCENTAJE_AMPLIACION_MARGENES_LATERALES = 2.0f;
	private static final float INTERLINEADO_PARRAFO_NORMAL = 12f;

	private static final int TAMANYO_FUENTE_TITULO = 15;
	private static final int TAMANYO_FUENTE_NORMAL = 10;
	private static final int TAMANYO_FUENTE_PIE = 9;

	//private static final Integer margenSup = 60;

	private float[] ANCHURAS_TABLA_CABECERA = { Aa17aConstantes.MAGIC_NUMBER_20, Aa17aConstantes.MAGIC_NUMBER_80 };

	private float[] ANCHURAS_TABLA_CRITERIOS = { Aa17aConstantes.MAGIC_NUMBER_20, Aa17aConstantes.MAGIC_NUMBER_80 };
	private float[] ANCHURAS_TABLA_DATOS_HORARIOS =
	{ Aa17aConstantes.MAGIC_NUMBER_24,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3
	};
	private float[] ANCHURAS_TABLA_DATOS_HORARIOS_HISTORICO =
	{ Aa17aConstantes.MAGIC_NUMBER_15,
			Aa17aConstantes.MAGIC_NUMBER_9,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3,
			Aa17aConstantes.MAGIC_NUMBER_3
	};

	private float[] ANCHURAS_TABLA_DATOS_DIARIOS_HISTORICO = {
			Aa17aConstantes.MAGIC_NUMBER_50,
			Aa17aConstantes.MAGIC_NUMBER_25,
			Aa17aConstantes.MAGIC_NUMBER_25
	};

	private Font fontCabeceraTabla;
	private Font fontTituloNegrita;
	private Font fontTextoNormalNegrita;
	private Font fontTextoNormal;
	private Font fontTextoPie;

	private Document document;

	//para formatear los decimales con coma (,)
	private DecimalFormat df = new DecimalFormat(Aa17aConstantes.FORMAT_BIGDECIMAL);

	/**
	 * 
	 * @param recurso
	 *            MessageSource
	 */
	public Aa17aInformesPDF(MessageSource recurso) {
		this.pdfMessageSource = recurso;
	}

	/**
	 * 
	 * @param doc
	 *            Document
	 * @param listDatosHorarios
	 *            List<Aa17aDatoHorario>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @throws Exception
	 *             e
	 */
	public void informeDatosHorarios(Document doc, List<Aa17aDatoHorario> listDatosHorarios, Aa17aInformeFiltro informeFiltro) throws Exception {

		this.document = doc;

		this.inicializarFuentes();

		this.document.resetPageCount();
		this.definirPie();

		//pongo el documento en horizontal
		this.document.setPageSize(PageSize.A4.rotate());

		this.definirCabeceraInforme();

		this.definirMargenes();

		this.definirTitulo("informe.datosHorarios");

		//inserto una linea vacia para dar espacio
		this.document.add(new Paragraph(new Chunk(" ")));

		this.dibujarCriteriosBusqueda(informeFiltro);

		//inserto una linea vacia para dar espacio
		this.document.add(new Paragraph(new Chunk(" ")));

		PdfPTable tblDatos = new PdfPTable(Aa17aConstantes.MAGIC_NUMBER_25);

		//fila caption de HORAS GMT
		tblDatos.addCell(this.celdaRegistro(""));
		tblDatos.addCell(this.filaCaptionHorasGMT());

		//Configuro la cabecera de la tabla
		tblDatos.addCell(this.celdaCabecera(this.getLiteral("informe.parametro")));
		tblDatos.addCell(this.celdaCabecera("1"));
		tblDatos.addCell(this.celdaCabecera("2"));
		tblDatos.addCell(this.celdaCabecera("3"));
		tblDatos.addCell(this.celdaCabecera("4"));
		tblDatos.addCell(this.celdaCabecera("5"));
		tblDatos.addCell(this.celdaCabecera("6"));
		tblDatos.addCell(this.celdaCabecera("7"));
		tblDatos.addCell(this.celdaCabecera("8"));
		tblDatos.addCell(this.celdaCabecera("9"));
		tblDatos.addCell(this.celdaCabecera("10"));
		tblDatos.addCell(this.celdaCabecera("11"));
		tblDatos.addCell(this.celdaCabecera("12"));
		tblDatos.addCell(this.celdaCabecera("13"));
		tblDatos.addCell(this.celdaCabecera("14"));
		tblDatos.addCell(this.celdaCabecera("15"));
		tblDatos.addCell(this.celdaCabecera("16"));
		tblDatos.addCell(this.celdaCabecera("17"));
		tblDatos.addCell(this.celdaCabecera("18"));
		tblDatos.addCell(this.celdaCabecera("19"));
		tblDatos.addCell(this.celdaCabecera("20"));
		tblDatos.addCell(this.celdaCabecera("21"));
		tblDatos.addCell(this.celdaCabecera("22"));
		tblDatos.addCell(this.celdaCabecera("23"));
		tblDatos.addCell(this.celdaCabecera("24"));

		for (Aa17aDatoHorario datoHorario : listDatosHorarios) {

			String nombreContaminante = datoHorario.getContaminante().getNombreContaminante() + " (" + datoHorario.getContaminante().getUnidadMedida() + ")";

			tblDatos.addCell(this.celdaRegistro(nombreContaminante));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora01())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora02())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora03())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora04())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora05())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora06())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora07())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora08())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora09())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora10())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora11())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora12())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora13())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora14())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora15())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora16())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora17())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora18())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora19())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora20())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora21())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora22())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora23())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora24())));

		}

		tblDatos.setWidths(this.ANCHURAS_TABLA_DATOS_HORARIOS);
		tblDatos.setWidthPercentage(new Float(Aa17aConstantes.MAGIC_NUMBER_100));

		this.document.add(tblDatos);

	}

	/**
	 * 
	 * @param doc
	 *            Document
	 * @param listDatosHorarios
	 *            List<Aa17aDatoHorario>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @throws Exception
	 *             e
	 */
	public void informeHistoricoDatosHorarios(Document doc, List<Aa17aDatoHorario> listDatosHorarios, Aa17aInformeFiltro informeFiltro) throws Exception {

		this.document = doc;

		this.inicializarFuentes();

		this.document.resetPageCount();
		this.definirPie();

		//pongo el documento en horizontal
		this.document.setPageSize(PageSize.A4.rotate());

		this.definirCabeceraInforme();

		this.definirMargenes();

		this.definirTitulo("informe.datosHorarios");

		//inserto una linea vacia para dar espacio
		this.document.add(new Paragraph(new Chunk(" ")));

		this.dibujarCriteriosBusqueda(informeFiltro);

		//inserto una linea vacia para dar espacio
		this.document.add(new Paragraph(new Chunk(" ")));

		PdfPTable tblDatos = new PdfPTable(Aa17aConstantes.MAGIC_NUMBER_26);

		//fila caption de HORAS GMT
		tblDatos.addCell(this.celdaRegistro(""));
		tblDatos.addCell(this.celdaRegistro(""));
		tblDatos.addCell(this.filaCaptionHorasGMT());

		//Configuro la cabecera de la tabla
		tblDatos.addCell(this.celdaCabecera(this.getLiteral("informe.parametro")));
		tblDatos.addCell(this.celdaCabecera(this.getLiteral("informe.fecha")));
		tblDatos.addCell(this.celdaCabecera("1"));
		tblDatos.addCell(this.celdaCabecera("2"));
		tblDatos.addCell(this.celdaCabecera("3"));
		tblDatos.addCell(this.celdaCabecera("4"));
		tblDatos.addCell(this.celdaCabecera("5"));
		tblDatos.addCell(this.celdaCabecera("6"));
		tblDatos.addCell(this.celdaCabecera("7"));
		tblDatos.addCell(this.celdaCabecera("8"));
		tblDatos.addCell(this.celdaCabecera("9"));
		tblDatos.addCell(this.celdaCabecera("10"));
		tblDatos.addCell(this.celdaCabecera("11"));
		tblDatos.addCell(this.celdaCabecera("12"));
		tblDatos.addCell(this.celdaCabecera("13"));
		tblDatos.addCell(this.celdaCabecera("14"));
		tblDatos.addCell(this.celdaCabecera("15"));
		tblDatos.addCell(this.celdaCabecera("16"));
		tblDatos.addCell(this.celdaCabecera("17"));
		tblDatos.addCell(this.celdaCabecera("18"));
		tblDatos.addCell(this.celdaCabecera("19"));
		tblDatos.addCell(this.celdaCabecera("20"));
		tblDatos.addCell(this.celdaCabecera("21"));
		tblDatos.addCell(this.celdaCabecera("22"));
		tblDatos.addCell(this.celdaCabecera("23"));
		tblDatos.addCell(this.celdaCabecera("24"));

		for (Aa17aDatoHorario datoHorario : listDatosHorarios) {

			String nombreContaminante = datoHorario.getContaminante().getNombreContaminante() + " (" + datoHorario.getContaminante().getUnidadMedida() + ")";

			tblDatos.addCell(this.celdaRegistro(nombreContaminante));
			tblDatos.addCell(this.celdaRegistro(Aa17aFuncionesComunes.formatearFecha(datoHorario.getFechaDato())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora01())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora02())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora03())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora04())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora05())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora06())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora07())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora08())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora09())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora10())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora11())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora12())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora13())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora14())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora15())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora16())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora17())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora18())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora19())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora20())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora21())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora22())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora23())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHorario.getValorHora24())));

		}

		tblDatos.setWidths(this.ANCHURAS_TABLA_DATOS_HORARIOS_HISTORICO);
		tblDatos.setWidthPercentage(new Float(Aa17aConstantes.MAGIC_NUMBER_100));

		this.document.add(tblDatos);

	}

	/**
	 * 
	 * @param doc
	 *            Document
	 * @param listDatosHistorico
	 *            List<Aa17aDatoHistorico>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @throws Exception
	 *             e
	 */
	public void informeHistoricoDatosDiarios(Document doc, List<Aa17aDatoHistorico> listDatosHistorico, Aa17aInformeFiltro informeFiltro) throws Exception {

		this.document = doc;

		this.inicializarFuentes();

		this.document.resetPageCount();
		this.definirPie();

		this.definirCabeceraInforme();

		this.definirMargenes();

		this.definirTitulo("informe.datosHitoricos.titulo");

		//inserto una linea vacia para dar espacio
		this.document.add(new Paragraph(new Chunk(" ")));

		this.dibujarCriteriosBusqueda(informeFiltro);

		//inserto una linea vacia para dar espacio
		this.document.add(new Paragraph(new Chunk(" ")));

		PdfPTable tblDatos = new PdfPTable(Aa17aConstantes.MAGIC_NUMBER_3);

		//Configuro la cabecera de la tabla
		tblDatos.addCell(this.celdaCabecera(this.getLiteral("informe.parametro")));
		tblDatos.addCell(this.celdaCabecera(this.getLiteral("informe.fecha")));
		tblDatos.addCell(this.celdaCabecera(this.getLiteral("informe.datosHitoricos.valor")));

		for (Aa17aDatoHistorico datoHistorico : listDatosHistorico) {

			String nombreContaminante = datoHistorico.getContaminante().getNombreContaminante().toString() + " (" + datoHistorico.getContaminante().getUnidadMedida().toString() + ")";

			tblDatos.addCell(this.celdaRegistro(nombreContaminante));
			tblDatos.addCell(this.celdaRegistro(Aa17aFuncionesComunes.formatearFecha(datoHistorico.getFechaDato())));
			tblDatos.addCell(this.celdaRegistro(this.convertBigDecimalToString(datoHistorico.getValorDiario())));
		}

		tblDatos.setWidths(this.ANCHURAS_TABLA_DATOS_DIARIOS_HISTORICO);
		tblDatos.setWidthPercentage(new Float(Aa17aConstantes.MAGIC_NUMBER_50));

		this.document.add(tblDatos);

	}

	/**
	 * 
	 * @param valor
	 *            BigDecimal
	 * @return String
	 */
	private String convertBigDecimalToString(BigDecimal valor) {

		String retorno = "";
		if (valor != null) {
			retorno = Aa17aFuncionesComunes.formatearBigDecimal(valor, this.df);
		}

		return retorno;
	}

	/**
	 * Función que dibuja los criterios de búsqueda seleccionados para generar
	 * el informe
	 * 
	 * @param informeFiltro
	 *            Y96bInformeFiltro
	 * @throws Exception
	 *             e
	 */
	private void dibujarCriteriosBusqueda(Aa17aInformeFiltro informeFiltro) throws Exception {

		PdfPTable tblCriterios = new PdfPTable(Aa17aConstantes.MAGIC_NUMBER_2);

		//Estacion
		if (informeFiltro.getNombreEstacion() != null) {
			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(this.getLiteral("informe.estacion"), true));
			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(informeFiltro.getNombreEstacion(), false));
		}

		//contaminantes
		if (informeFiltro.getListaNombresContaminantes() != null && informeFiltro.getListaNombresContaminantes().size() > 0) {

			StringBuilder cadena = new StringBuilder();

			for (String nombre : informeFiltro.getListaNombresContaminantes()) {
				cadena.append(" - ");
				cadena.append(nombre);
			}

			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(this.getLiteral("informe.parametros") + ":", true));
			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(cadena.toString(), false));
		}

		//Fecha
		if (informeFiltro.getFecha() != null) {
			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(this.getLiteral("informe.fecha") + ":", true));
			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFecha(), this.locale), false));
		}

		//Fecha Desde y Fecha Hasta
		if (informeFiltro.getFechaDesde() != null || informeFiltro.getFechaHasta() != null) {
			StringBuilder cadena = new StringBuilder();
			if (informeFiltro.getFechaDesde() != null) {
				cadena.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFechaDesde(), this.locale));
				cadena.append(" - ");
			}
			if (informeFiltro.getFechaHasta() != null) {
				cadena.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFechaHasta(), this.locale));
			}

			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(this.getLiteral("informe.fecha") + ":", true));
			tblCriterios.addCell(this.generarCeldaCriteriosBusqueda(cadena.toString(), false));
		}

		tblCriterios.setWidths(this.ANCHURAS_TABLA_CRITERIOS);
		tblCriterios.setWidthPercentage(new Float(Aa17aConstantes.MAGIC_NUMBER_100));

		this.document.add(tblCriterios);

	}

	/**
	 * 
	 * @param texto
	 *            String
	 * @param blnLabel
	 *            Boolean
	 * @return PdfPCell
	 */
	private PdfPCell generarCeldaCriteriosBusqueda(String texto, Boolean blnLabel) {

		PdfPCell celda = new PdfPCell();
		celda.setBorderWidth(Aa17aConstantes.MAGIC_NUMBER_0);
		celda.setBackgroundColor(new Color(Aa17aConstantes.COLOR_CRITERIOS_INFORME_R, Aa17aConstantes.COLOR_CRITERIOS_INFORME_G, Aa17aConstantes.COLOR_CRITERIOS_INFORME_B));
		Paragraph parrafo = new Paragraph();//usamos un párrafo porque el alineado justifiacdo no lo coge la celda pero sí el párrafo.
		parrafo.setLeading(Aa17aInformesPDF.INTERLINEADO_PARRAFO_NORMAL);
		parrafo.setAlignment(Element.ALIGN_JUSTIFIED);

		if (blnLabel) {
			parrafo.add(new Chunk(texto, this.fontTextoNormalNegrita));
		}
		else {
			parrafo.add(new Chunk(texto, this.fontTextoNormal));
		}

		celda.addElement(parrafo);

		return celda;
	}

	/**
	 * 
	 * @return PdfPCell
	 */
	private PdfPCell filaCaptionHorasGMT() {

		PdfPCell celda = new PdfPCell();
		celda.setBorderWidth(Aa17aConstantes.MAGIC_NUMBER_1);
		celda.setBackgroundColor(new Color(Aa17aConstantes.COLOR_CABECERA_INFORME_R, Aa17aConstantes.COLOR_CABECERA_INFORME_G, Aa17aConstantes.COLOR_CABECERA_INFORME_B));
		celda.setColspan(Aa17aConstantes.MAGIC_NUMBER_24);

		Paragraph parrafo = new Paragraph();//usamos un párrafo porque el alineado justifiacdo no lo coge la celda pero sí el párrafo.
		parrafo.setLeading(Aa17aInformesPDF.INTERLINEADO_PARRAFO_NORMAL);
		parrafo.setAlignment(Element.ALIGN_CENTER);
		parrafo.setFont(this.fontCabeceraTabla);

		parrafo.add(new Chunk(this.getLiteral("informe.datosHorarios.horasGMT"), this.fontTextoNormalNegrita));

		celda.addElement(parrafo);

		return celda;
	}

	/**
	 * 
	 * @param texto
	 *            String
	 * @return PdfPCell
	 */
	private PdfPCell celdaCabecera(String texto) {

		PdfPCell celda = new PdfPCell();
		celda.setBorderWidth(Aa17aConstantes.MAGIC_NUMBER_1);
		celda.setBackgroundColor(new Color(Aa17aConstantes.COLOR_CABECERA_INFORME_R, Aa17aConstantes.COLOR_CABECERA_INFORME_G, Aa17aConstantes.COLOR_CABECERA_INFORME_B));

		Paragraph parrafo = new Paragraph();//usamos un párrafo porque el alineado justifiacdo no lo coge la celda pero sí el párrafo.
		parrafo.setLeading(Aa17aInformesPDF.INTERLINEADO_PARRAFO_NORMAL);
		parrafo.setAlignment(Element.ALIGN_CENTER);
		parrafo.setFont(this.fontCabeceraTabla);

		parrafo.add(new Chunk(texto, this.fontTextoNormalNegrita));

		celda.addElement(parrafo);

		return celda;
	}

	/**
	 * 
	 * @param texto
	 *            String
	 * @return PdfPCell
	 */
	private PdfPCell celdaRegistro(String texto) {

		PdfPCell celda = new PdfPCell();
		celda.setBorderWidth(Aa17aConstantes.MAGIC_NUMBER_1);
		//celda.setBackgroundColor(new Color(Aa17aConstantes.COLOR_CABECERA_INFORME_R, Aa17aConstantes.COLOR_CABECERA_INFORME_G, Aa17aConstantes.COLOR_CABECERA_INFORME_B));
		//celda.setPadding(0);

		Paragraph parrafo = new Paragraph();//usamos un párrafo porque el alineado justifiacdo no lo coge la celda pero sí el párrafo.
		parrafo.setLeading(Aa17aInformesPDF.INTERLINEADO_PARRAFO_NORMAL);
		parrafo.setAlignment(Element.ALIGN_JUSTIFIED);

		parrafo.add(new Chunk(texto, this.fontTextoNormal));

		celda.addElement(parrafo);

		return celda;
	}

	/**
	 * Método donde se define el título del documento
	 * 
	 * @param sourceTitulo
	 *            String
	 * @throws Exception
	 *             e
	 */
	private void definirTitulo(String sourceTitulo) throws Exception {

		try {

			/**
			 * Titulo
			 */
			Paragraph phTitulo = new Paragraph();
			//phTitulo.add("\n");
			phTitulo.add(new Chunk(this.getLiteral(sourceTitulo), this.fontTituloNegrita));
			phTitulo.add("\n");
			phTitulo.setAlignment(Element.ALIGN_CENTER);
			//phTitulo.setLeading(Y96bPdfDocumentoNotifTelematica.INTERLINEADO_PARRAFO_TITULO);

			this.document.add(phTitulo);

		} catch (Exception e) {
			throw e;
		}

	}

	/**
	 * 
	 */
	private void definirMargenes() {

		Float margenOrigArriba = this.document.topMargin();
		Float margenOrigAbajo = this.document.bottomMargin();
		Float margenOrigIzq = this.document.leftMargin();
		Float margenOrigDcha = this.document.rightMargin();

		//Reducimos los márgenes para la primera página (por eso se hace ANTES del open())
		this.document.setMargins(new Float(margenOrigIzq * Aa17aInformesPDF.PORCENTAJE_AMPLIACION_MARGENES_LATERALES),
				new Float(margenOrigDcha * Aa17aInformesPDF.PORCENTAJE_AMPLIACION_MARGENES_LATERALES),
				new Float(margenOrigArriba / Aa17aConstantes.MAGIC_NUMBER_3),
				new Float(margenOrigAbajo / Aa17aConstantes.MAGIC_NUMBER_3));

		/**
		 * NOTA: no es necesario hacer el "openDocument()", pero lo hacemos TRAS
		 * definir el footer y ANTES de meter el resto de contenidos porque
		 * sino, no se pinta el footer en la primera página.
		 * */

		this.document.open();

		/*this.document.setMargins(new Float(margenOrigIzq * Aa17aInformesPDF.PORCENTAJE_AMPLIACION_MARGENES_LATERALES),
				new Float(margenOrigDcha * Aa17aInformesPDF.PORCENTAJE_AMPLIACION_MARGENES_LATERALES),
				new Float(margenOrigArriba + Aa17aInformesPDF.margenSup),
				new Float(margenOrigAbajo / Aa17aConstantes.MAGIC_NUMBER_3));*/

	}

	/**
	 * 
	 *
	 */
	private void definirPie() {

		/**
		 * Definimos el footer ANTES de abrir el documento
		 * */

		HeaderFooter pie = new HeaderFooter(new Phrase("", this.fontTextoPie), true);

		pie.setAlignment(Element.ALIGN_RIGHT);
		pie.setBorderWidthBottom(Aa17aConstantes.MAGIC_NUMBER_0);

		this.document.setFooter(pie);

	}

	/**
	 * 
	 * @throws Exception
	 *             e
	 */
	private void definirCabeceraInforme() throws Exception {

		try {

			Image headerImagenLogo = Image.getInstance(Aa17aConstantes.INFORME_IMAGEN_LOGO_GV);
			headerImagenLogo.scalePercent(Aa17aInformesPDF.ESCALA_IMAGEN);

			Phrase fraseCabecera = new Phrase(new Chunk(headerImagenLogo, Aa17aConstantes.MAGIC_NUMBER_0, Aa17aConstantes.MAGIC_NUMBER_0));

			PdfPTable tblCab = new PdfPTable(Aa17aConstantes.MAGIC_NUMBER_2);
			tblCab.getDefaultCell().setBorderWidth(Aa17aConstantes.MAGIC_NUMBER_0);

			tblCab.addCell(fraseCabecera);

			PdfPCell celda = new PdfPCell();
			celda.setBorderWidth(Aa17aConstantes.MAGIC_NUMBER_0);

			Paragraph parrafo = new Paragraph();//usamos un párrafo porque el alineado justifiacdo no lo coge la celda pero sí el párrafo.
			parrafo.setLeading(Aa17aInformesPDF.INTERLINEADO_PARRAFO_NORMAL);
			parrafo.setAlignment(Element.ALIGN_RIGHT);

			parrafo.add(new Chunk(this.getLiteral("informe.titulo"), this.fontTextoNormalNegrita));
			parrafo.add(new Chunk("\n", this.fontTextoNormal));
			parrafo.add(new Chunk("www.ingurumena.ejgv.euskadi.net", this.fontTextoNormal));

			celda.addElement(parrafo);

			tblCab.addCell(celda);

			//Linea de separacion entre la cabecera y el contenido de la página
			tblCab.addCell("\n\n");
			tblCab.addCell("\n\n");

			Phrase cab = new Phrase();
			cab.add(tblCab);

			tblCab.setWidths(this.ANCHURAS_TABLA_CABECERA);
			tblCab.setWidthPercentage(new Float(Aa17aConstantes.MAGIC_NUMBER_100));

			HeaderFooter header = new HeaderFooter(cab, false);

			header.setBorder(Aa17aConstantes.MAGIC_NUMBER_0);
			header.setAlignment(HeaderFooter.ALIGN_BOTTOM);
			header.setAlignment(HeaderFooter.ALIGN_LEFT);

			this.document.setHeader(header);

		} catch (Exception e) {
			throw e;
		}

	}

	/**
	 * Método para definir las fuentes
	 * 
	 * @throws Exception
	 *             e
	 */
	private void inicializarFuentes() throws Exception {
		try {

			this.fontCabeceraTabla = new Font(Font.TIMES_ROMAN, Aa17aInformesPDF.TAMANYO_FUENTE_NORMAL, Font.BOLD, new Color(Aa17aConstantes.MAGIC_NUMBER_255, Aa17aConstantes.MAGIC_NUMBER_255, Aa17aConstantes.MAGIC_NUMBER_255));
			this.fontTituloNegrita = new Font(Font.TIMES_ROMAN, Aa17aInformesPDF.TAMANYO_FUENTE_TITULO, Font.BOLD);
			this.fontTextoNormalNegrita = new Font(Font.TIMES_ROMAN, Aa17aInformesPDF.TAMANYO_FUENTE_NORMAL, Font.BOLD);
			this.fontTextoNormal = new Font(Font.TIMES_ROMAN, Aa17aInformesPDF.TAMANYO_FUENTE_NORMAL);
			this.fontTextoPie = new Font(Font.TIMES_ROMAN, Aa17aInformesPDF.TAMANYO_FUENTE_PIE);
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String getLiteral(String key) {
		return this.pdfMessageSource.getMessage(key, null, this.locale);
	}

	/**
	 * @param pdfMessageSource
	 *            the pdfMessageSource to set
	 */
	public void setPdfMessageSource(MessageSource pdfMessageSource) {
		this.pdfMessageSource = pdfMessageSource;
	}

	/**
	 * @return the pdfMessageSource
	 */
	public MessageSource getPdfMessageSource() {
		return this.pdfMessageSource;
	}

}